#!/usr/bin/perl
use strict;
use warnings;
use v5.10;

use REST::Client;
use Perl::Version;
use File::Which;
use JSON::MaybeXS;

die "No opengist\n" unless which 'opengist';
die "No forgejo\n"  unless which 'forgejo';

my $gversion = Perl::Version->new( substr `opengist version`, 9 );
my $gurl = "https://api.github.com/repos/thomiceli/opengist/releases/latest";
my $gh   = REST::Client->new();
$gh->GET( $gurl, { "accept" => "application/vnd.github+json" } );
my $gcontent  = decode_json $gh->responseContent();
my $ngversion = Perl::Version->new( $gcontent->{'name'} );
my $gdurl;
my $gname;

if ( $gversion < $ngversion ) {
    `systemctl stop opengist`;
    my @assets = @{ $gcontent->{'assets'} };
    foreach my $assets (@assets) {
        if ( $assets->{'name'} =~ /linux-amd64/ ) {
            $gname = $assets->{'name'};
            $gdurl = $assets->{'browser_download_url'};
        }
    }
    print `aria2c $gdurl`;
    print `tar xvf $gname`;
    print `cp opengist/opengist /usr/local/bin/opengist -v`;
    `systemctl restart opengist`;
    print `rm -v $gname && rm -rvf opengist/`;
    say "Updated opengist!";
}
else {
    say "No need update opengist!";
}

my @fout     = split( / /, `forgejo -v` );
my $fversion = Perl::Version->new( substr $fout[5], 0, -1 );
my $furl = "https://codeberg.org/api/v1/repos/forgejo/forgejo/releases/latest";
my $f    = REST::Client->new();
$f->GET( $furl, { "accept" => "application/json" } );
my $fcontent  = decode_json $f->responseContent();
my $nfversion = Perl::Version->new( $fcontent->{'name'} );
my $fdurl;
my $fname;

if ( $fversion < $nfversion ) {
    `systemctl stop forgejo`;
    my @assets = @{ $fcontent->{'assets'} };
    foreach my $assets (@assets) {
        if ( $assets->{'name'} =~ /linux-amd64$/ ) {
            $fname = $assets->{'name'};
            $fdurl = $assets->{'browser_download_url'};
        }
    }
    print `aria2c $fdurl`;
    print `chmod +x $fname -v`;
    print `mv $fname /usr/local/bin/forgejo -v`;
    `systemctl restart forgejo`;
    say "Updated forgejo!";
}
else {
    say "No need update forgejo!";
}
