#!/usr/bin/perl
use strict;
use warnings;
use v5.10;

use REST::Client;
use Perl::Version;
use File::Which;
use JSON::MaybeXS;

die "No opengist\n" unless which 'opengist';
die "No forgejo\n"  unless which 'forgejo';

my $gversion = Perl::Version->new( substr `opengist version`, 9 );
my $gurl = "https://api.github.com/repos/thomiceli/opengist/releases/latest";
my $gh   = REST::Client->new();
$gh->GET( $gurl, { "accept" => "application/vnd.github+json" } );
my $gcontent  = decode_json $gh->responseContent();
my $ngversion = Perl::Version->new( $gcontent->{'name'} );
my $gdurl;
my $gname;

if ( $gversion < $ngversion ) {
    `systemctl stop opengist`;
    my @assets = @{ $gcontent->{'assets'} };
    foreach my $assets (@assets) {
        if ( $assets->{'name'} =~ /linux-amd64/ ) {
            $gname = $assets->{'name'};
            $gdurl = $assets->{'browser_download_url'};
        }
    }
    `aria2c $gdurl`;
    `tar xvf $gname`;
    `cp opengist/opengist /usr/local/bin/opengist -v`;
    `systemctl restart opengist`;
    `rm -v $gname`;
    say "Updated opengist!";
}
else{
    say "No need update opengist!"
}

my @fout     = split( / /, `forgejo -v` );
my $fversion = substr $fout[5], 0, -1;
