$baseDir = "D:\msvc"
$msvcVer = "14.50.35717"
$sdkVer  = "10.0.26100.0"

$msvcRoot = "$baseDir\VC\Tools\MSVC\$msvcVer"
$sdkRoot  = "$baseDir\Windows Kits\10"

# 路径导航
$env:BAZEL_VC = $msvcRoot
$env:BAZEL_VC_FULL_VERSION = $msvcVer # 建议保留，Bazel 有时会校验

# 编译器查找路径 (INCLUDE)
$env:INCLUDE = @(
    "$msvcRoot\include",
    "$sdkRoot\Include\$sdkVer\ucrt",
    "$sdkRoot\Include\$sdkVer\shared",
    "$sdkRoot\Include\$sdkVer\um"
) -join ";"

# 链接器查找路径 (LIB)
$env:LIB = @(
    "$msvcRoot\lib\x64",
    "$sdkRoot\Lib\$sdkVer\ucrt\x64",
    "$sdkRoot\Lib\$sdkVer\um\x64",
    "$sdkRoot\bin\$sdkVer\x64\ucrt"
) -join ";"

# 可执行程序路径 (PATH)
# 确保你的 LLVM 路径也在里面
$binPaths = @(
    "$msvcRoot\bin\Hostx64\x64",
    "$sdkRoot\bin\$sdkVer\x64",
    "$sdkRoot\bin\$sdkVer\x64\ucrt"
)
$env:PATH = ($binPaths -join ";") + ";" + $env:PATH

Write-Host "Build environment configured for MSVC" 