local wt = require("wezterm");
local TabBackground = "#000"
local TabForeground = "#aaa"
local TabForegroundActive = "#fff"
function string.split(str, sep)
	local t = {}
	for s in string.gmatch(str, "([^" .. sep .. "]+)") do
		table.insert(t, s)
	end
	return t
end

function reduce_title(title)
	title = title:gsub("\\", "/")
	title = title:split("/")
	return title[#title]
end

wt.on("format-tab-title", function(tab, tabs, panes, config, hover, max_width)
	return reduce_title(tab.active_pane.title)
end)
wt.on("format-window-title", function(tab, pane, tabs, panes, config)
	return reduce_title(tab.active_pane.title)
end)
return {
	color_scheme = "Monokai Remastered",
	colors = {
		tab_bar = {
			background = TabBackground,
			active_tab = {
				bg_color = TabBackground,
				fg_color = TabForegroundActive,
				intensity = "Bold",
			},
			inactive_tab = {
				bg_color = TabBackground,
				fg_color = TabForeground,
				intensity = "Normal",
			},
			inactive_tab_hover = {
				bg_color = TabBackground,
				fg_color = TabForegroundActive,
				intensity = "Normal",
			},
			new_tab = {
				bg_color = TabBackground,
				fg_color = TabForeground,
			},
			new_tab_hover = {
				bg_color = TabBackground,
				fg_color = TabForegroundActive,
			},
		},
	},
	initial_cols = 100,
	initial_rows = 30,
	font = wt.font("等距更纱黑体 SC"),
	font_size = 14,
	default_cursor_style = "BlinkingBar",
	cursor_blink_rate = 500,
	-- hide_tab_bar_if_only_one_tab = true,
	-- window_background_opacity = 0.85,
	default_prog = { "D:/PowerShell/7/pwsh.exe"},
	alternate_buffer_wheel_scroll_speed = 1,
	window_padding = {
		left = 0,
		right = 0,
		top = 0,
		bottom = 0,
	},
	keys = {
		{
			key = "t",
			mods = "CTRL",
			action = wt.action {
				SpawnTab = "DefaultDomain",
			},
		},
		{
			key = "V",
			mods = "SHIFT|CTRL",
			action = wt.action.PasteFrom 'Clipboard'
		},
		{
			key = "RightArrow",
			mods = "ALT",
			action = wt.action {
				ActivateTabRelative = 1,
			},
		},
		{
			key = "LeftArrow",
			mods = "ALT",
			action = wt.action {
				ActivateTabRelative = -1,
			},
		},
	},
	mouse_bindings = {
		-- Change the default click behavior so that it populates
		-- the Clipboard rather the PrimarySelection.
		{
			event = { Up = { streak = 1, button = 'Left' } },
			mods = 'NONE',
			action = wt.action.CompleteSelectionOrOpenLinkAtMouseCursor 'Clipboard',
		},
		{
			event = { Up = { streak = 1, button = 'Right' } },
			mods = 'NONE',
			action = wt.action.PasteFrom 'Clipboard',
		}
	},
}
